/*
 * Decompiled with CFR 0.152.
 */
package net.coderbot.iris.shaderpack.option;

import com.google.common.collect.ImmutableMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.coderbot.iris.shaderpack.include.AbsolutePackPath;
import net.coderbot.iris.shaderpack.include.IncludeGraph;
import net.coderbot.iris.shaderpack.option.OptionAnnotatedSource;
import net.coderbot.iris.shaderpack.option.OptionSet;
import net.coderbot.iris.shaderpack.option.values.MutableOptionValues;
import net.coderbot.iris.shaderpack.option.values.OptionValues;

public class ShaderPackOptions {
    private final OptionSet optionSet;
    private final OptionValues optionValues;
    private final IncludeGraph includes;

    public ShaderPackOptions(IncludeGraph includeGraph2, Map<String, String> map) {
        HashMap hashMap = new HashMap();
        OptionSet.Builder builder = OptionSet.builder();
        includeGraph2.computeWeaklyConnectedComponents().forEach(includeGraph -> {
            ImmutableMap.Builder builder2 = ImmutableMap.builder();
            HashSet hashSet = new HashSet();
            includeGraph.getNodes().forEach((absolutePackPath, fileNode) -> {
                OptionAnnotatedSource optionAnnotatedSource = new OptionAnnotatedSource(fileNode.getLines());
                builder2.put(absolutePackPath, (Object)optionAnnotatedSource);
                hashSet.addAll(optionAnnotatedSource.getBooleanDefineReferences().keySet());
            });
            ImmutableMap immutableMap = builder2.build();
            Set set = Collections.unmodifiableSet(hashSet);
            immutableMap.forEach((absolutePackPath, optionAnnotatedSource) -> {
                OptionSet optionSet = optionAnnotatedSource.getOptionSet((AbsolutePackPath)absolutePackPath, set);
                builder.addAll(optionSet);
            });
            hashMap.putAll(immutableMap);
        });
        this.optionSet = builder.build();
        this.optionValues = new MutableOptionValues(this.optionSet, map);
        this.includes = includeGraph2.map(absolutePackPath -> ((OptionAnnotatedSource)hashMap.get(absolutePackPath)).asTransform(this.optionValues));
    }

    public OptionSet getOptionSet() {
        return this.optionSet;
    }

    public OptionValues getOptionValues() {
        return this.optionValues;
    }

    public IncludeGraph getIncludes() {
        return this.includes;
    }
}

